<?php

namespace App\Test\Controller;

use App\Entity\Application;
use App\Repository\ApplicationRepository;
use Symfony\Bundle\FrameworkBundle\KernelBrowser;
use Symfony\Bundle\FrameworkBundle\Test\WebTestCase;

class ApplicationControllerTest extends WebTestCase
{
    private KernelBrowser $client;
    private ApplicationRepository $repository;
    private string $path = '/application/';

    protected function setUp(): void
    {
        $this->client = static::createClient();
        $this->repository = (static::getContainer()->get('doctrine'))->getRepository(Application::class);

        foreach ($this->repository->findAll() as $object) {
            $this->repository->remove($object, true);
        }
    }

    public function testIndex(): void
    {
        $crawler = $this->client->request('GET', $this->path);

        self::assertResponseStatusCodeSame(200);
        self::assertPageTitleContains('Application index');

        // Use the $crawler to perform additional assertions e.g.
        // self::assertSame('Some text on the page', $crawler->filter('.p')->first());
    }

    public function testNew(): void
    {
        $originalNumObjectsInRepository = count($this->repository->findAll());

        $this->markTestIncomplete();
        $this->client->request('GET', sprintf('%snew', $this->path));

        self::assertResponseStatusCodeSame(200);

        $this->client->submitForm('Save', [
            'application[name]' => 'Testing',
            'application[dateCreated]' => 'Testing',
            'application[applicationPass]' => 'Testing',
            'application[httpLink]' => 'Testing',
            'application[apiLink]' => 'Testing',
            'application[apiBackLink]' => 'Testing',
        ]);

        self::assertResponseRedirects('/application/');

        self::assertSame($originalNumObjectsInRepository + 1, count($this->repository->findAll()));
    }

    public function testShow(): void
    {
        $this->markTestIncomplete();
        $fixture = new Application();
        $fixture->setName('My Title');
        $fixture->setDateCreated('My Title');
        $fixture->setApplicationPass('My Title');
        $fixture->setHttpLink('My Title');
        $fixture->setApiLink('My Title');
        $fixture->setApiBackLink('My Title');

        $this->repository->add($fixture, true);

        $this->client->request('GET', sprintf('%s%s', $this->path, $fixture->getId()));

        self::assertResponseStatusCodeSame(200);
        self::assertPageTitleContains('Application');

        // Use assertions to check that the properties are properly displayed.
    }

    public function testEdit(): void
    {
        $this->markTestIncomplete();
        $fixture = new Application();
        $fixture->setName('My Title');
        $fixture->setDateCreated('My Title');
        $fixture->setApplicationPass('My Title');
        $fixture->setHttpLink('My Title');
        $fixture->setApiLink('My Title');
        $fixture->setApiBackLink('My Title');

        $this->repository->add($fixture, true);

        $this->client->request('GET', sprintf('%s%s/edit', $this->path, $fixture->getId()));

        $this->client->submitForm('Update', [
            'application[name]' => 'Something New',
            'application[dateCreated]' => 'Something New',
            'application[applicationPass]' => 'Something New',
            'application[httpLink]' => 'Something New',
            'application[apiLink]' => 'Something New',
            'application[apiBackLink]' => 'Something New',
        ]);

        self::assertResponseRedirects('/application/');

        $fixture = $this->repository->findAll();

        self::assertSame('Something New', $fixture[0]->getName());
        self::assertSame('Something New', $fixture[0]->getDateCreated());
        self::assertSame('Something New', $fixture[0]->getApplicationPass());
        self::assertSame('Something New', $fixture[0]->getHttpLink());
        self::assertSame('Something New', $fixture[0]->getApiLink());
        self::assertSame('Something New', $fixture[0]->getApiBackLink());
    }

    public function testRemove(): void
    {
        $this->markTestIncomplete();

        $originalNumObjectsInRepository = count($this->repository->findAll());

        $fixture = new Application();
        $fixture->setName('My Title');
        $fixture->setDateCreated('My Title');
        $fixture->setApplicationPass('My Title');
        $fixture->setHttpLink('My Title');
        $fixture->setApiLink('My Title');
        $fixture->setApiBackLink('My Title');

        $this->repository->add($fixture, true);

        self::assertSame($originalNumObjectsInRepository + 1, count($this->repository->findAll()));

        $this->client->request('GET', sprintf('%s%s', $this->path, $fixture->getId()));
        $this->client->submitForm('Delete');

        self::assertSame($originalNumObjectsInRepository, count($this->repository->findAll()));
        self::assertResponseRedirects('/application/');
    }
}
